<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/GestoreUpload.php";
    include "../../../../gUtil/ElaboratoreImmagini.php";
    include "../classi/Banner.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $banner = new Banner($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $banner = new Banner($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    $impostazioni = recuperaImpostazioni($geecomDb);
    
    switch ($operazione) {
        case 'crea':
            $banner->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $banner->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $banner->setAnimazione(filter_input(INPUT_POST,"animazione",FILTER_SANITIZE_STRING));
            $banner->setDataCreazione(filter_input(INPUT_POST,"dataCreazione",FILTER_SANITIZE_STRING));
            $banner->crea();
            header("Location: ../creaBanner.php?id={$banner->getId()}&status=200");
            break;
        case 'modifica':
            $banner->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $banner->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $banner->setAnimazione(filter_input(INPUT_POST,"animazione",FILTER_SANITIZE_STRING));
            $banner->setDataCreazione(filter_input(INPUT_POST,"dataCreazione",FILTER_SANITIZE_STRING));
            $banner->modifica();
            header("Location: ../creaBanner.php?id={$banner->getId()}&status=250");
            break;
        case 'elimina':
            $banner->elimina();
            echo "ok";
            break;
        case 'duplica':
            $banner->caricaDatiDalDatabase();
            $idNuovaForm = $banner->duplica();
            header("Location: ../creaBanner.php?id={$idNuovaForm}&status=260");
            break;
        case 'stampaElementi':
            $banner->stampaElementi();
            break;
        case 'creaElemento':
            $nome = filter_input(INPUT_POST, "nome",FILTER_SANITIZE_STRING);
            $link = filter_input(INPUT_POST, "link",FILTER_SANITIZE_STRING);
            $banner->creaElemento($nome,$link);
            echo "ok";
            break;
        case 'modificaElemento':
            $idElemento = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $nome       = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_STRING);
            $link       = filter_input(INPUT_POST,"link",FILTER_SANITIZE_STRING);
            $attiva     = filter_input(INPUT_POST,"attiva",FILTER_SANITIZE_STRING);
            
            // può essere attiva una sola campagna contemporaneamente, quindi se questa campagna va attivata devono essere prima
            // disattivate tutte le altre
            if($attiva=="si") {
                $datiELemento = $geecomDb->leggiSingolaRiga("geec_campagneBanner", $idElemento);
                $geecomDb->eseguiQueryLettura("UPDATE geec_campagneBanner SET attiva='no' WHERE idBanner = {$datiELemento["idBanner"]}");
            }
            
            $banner->modificaElemento($idElemento,$nome, $link,$attiva);
            header("Location: ../creaElemento.php?id={$idElemento}&status=200");
            break;
        case 'modificaImmagineDesktop':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/altro", 0);
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $banner->cambiaImmagineDesktopElemento($idElemento,$percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'eliminaImmagineElemento':
            $idElemento  = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $banner->cambiaImmagineDesktopElemento($idElemento,"");
            echo "ok";
            break;
        case 'modificaImmagineElementoConPercorso':
            $idElemento = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $percorso   = filter_input(INPUT_POST, "percorso",FILTER_SANITIZE_STRING);
            $banner->cambiaImmagineDesktopElemento($idElemento,$percorso);
            echo "ok";
            break;
        case 'modificaImmagineMobile':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/altro", 0);
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $banner->cambiaImmagineMobileElemento($idElemento,$percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'modificaImmagineMobileConPercorso':
            $idElemento = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $percorso   = filter_input(INPUT_POST, "percorso",FILTER_SANITIZE_STRING);
            $banner->cambiaImmagineMobileElemento($idElemento,$percorso);
            echo "ok";
            break;
        case 'eliminaImmagineMobile':
            $idElemento  = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $banner->cambiaImmagineMobileElemento($idElemento,"");
            echo "ok";
            break;
        case 'eliminaElemento':
            $banner->eliminaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
    }
